'''
#################################################################################
#                                                                               #
#    Lonnox CUT - module Rawpart                                                #
#                                                                               #
#################################################################################
#	C O N T E N T                                								#
#-------------------------------------------------------------------------------#
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#    02.00 g-code generator                                                     #
#        02.01 local vars                                                       #
#        02.02 mirror module on x-axis                                          #
#        02.03 startcodes                                                       #
#        02.04 g-code generation for module                                     #
#        02.05 end codes                                                        #
#                                                                               #
#    03.00 determine start-/endtool                                             #
#                                                                               #
#################################################################################
'''
__version__ = '1.0'
__license__ = "license.txt"
__author__ = 'Kai Masemann <info@lonnox.de>'

#################################################################################
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#################################################################################

#---libraries for the layout---
import math
import os
import sys
import gcode
import uni


#################################################################################
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#################################################################################

#---choose/ add section in the module tree---
section    = "General"

#---name of the module in the tree---
name       = "Rawpart"
groupEnd   = ""

#---explain picture of the module--- 
picture    = "Rawpart.png"

#---explaining text for helpbutton in lonnox cut---
info = "RawInfo"

#---predefined tools---
predefinedTools = False

#---widgets that are displayed to set the parameters---
# T=Text, N=NumberValues, O=OptionList, F=FileButton, C=CheckBox
widget = ("N","N","O","N","N","N","N","N")

#---parameter of the module---
labels    = ("Zero Point X", "Zero Point Y","Orientation","X","Y",
             "Width (a)","Height (b)","Thickness")

#---option presets for listed parameters---
options   = {"Orientation":      ("Normal","Mirror") }



class module( object ):
    #############################################################################
    #                                                                           #
    #    02.00 g-code generator                                                 #
    #                                                                           #
    #############################################################################
    def gcode( self, jTools, joblist, jIndex, preview=0 ):
        global name
        L = uni.language 

        #########################################################################
        #    02.01 local vars                                                   #
        #########################################################################

        #---extrace name, tool and param rows from joblist table---
        jNames = [job[1] for job in joblist]
        jParams = [job[2:] for job in joblist] #for contents, see labels

        #---variable values---
        if name in uni.language: LName = uni.language[name]
        else: LName = name
        code          = "\n(" + ("-"*30) + LName + jNames[jIndex][-4:] + ("-"*30) + ")\n\n"
        x0            = jParams[jIndex][0] 
        y0            = jParams[jIndex][1] 
        orient        = jParams[jIndex][2]
        x             = jParams[jIndex][3] + x0 
        y             = jParams[jIndex][4] + y0 
        w             = jParams[jIndex][5] 
        h             = jParams[jIndex][6]
        thick         = jParams[jIndex][7]          
        mirrorstops   = uni.settings[1]
        zSave         = uni.settings[4]
 
        #---escape if essetial values are missing---
        if not w or not h: return code
 

        #########################################################################
        #    02.02 change values by options                                     #
        #########################################################################

        #---recalculate mirror values---
        if orient == "Mirror": x = mirrorstops - x - w


        #########################################################################
        #    02.03 startcodes                                                   #
        #########################################################################
        #feature not used in this module


        #########################################################################
        #    02.04 tool activation optimizer                                    #
        #########################################################################
        #feature not used in this module
        
        
        #########################################################################
        #    02.05 g-code generation for module                                 #
        #########################################################################

        #---move to position---
        code += "({}: X{:.1f} Y{:.1f} a{:.1f} b{:.1f} {}{:.1f})\n\n".format( L["Rawpart"],
                                                                             x,
                                                                             y,
                                                                             w,
                                                                             h,
                                                                             L["Thickness"],
                                                                             thick )
        

        #########################################################################
        #    02.06 tool deactivation optimizer                                  #
        #########################################################################
        #feature not used in this module


        #########################################################################
        #    02.07 end codes                                                    #
        #########################################################################
        #feature not used in this module

        return code 
   

   
    #############################################################################
    #                                                                           #
    #    03.00 determine start-/endtool                                         #
    #                                                                           #
    #############################################################################
    # function returns start/endtool of THIS module for toolOptimizer 
    # "" will be ignored by optimizer 
    # "nT" will force to load no Tool
    def tool( self, joblist, jIndex ):
        
        return ("","") #(Start, Endtool)

        