'''
#################################################################################
#                                                                               #
#    Lonnox CUT - module Toolchane                                              #
#                                                                               #
#################################################################################
#	C O N T E N T                                								#
#-------------------------------------------------------------------------------#
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#    02.00 g-code generator                                                     #
#        02.01 local vars                                                       #
#                                                                               #
#    03.00 determine start-/endtool                                             #
#                                                                               #
#################################################################################
'''
__version__ = '1.0'
__license__ = "license.txt"
__author__ = 'Kai Masemann <info@lonnox.de>'

#################################################################################
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#################################################################################

#---libraries for the layout---
import math
import os
import sys
import gcode
import uni


#################################################################################
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#################################################################################

#---choose/ add section in the module tree---
section    = "General"

#---name of the module in the tree---
name       = "Tool - manual"
groupEnd   = ""

#---explain picture of the module--- 
picture    = "ToolManual.png"

#---explaining text for helpbutton in lonnox cut---
info = "ToolchangeMInfo"

#---predefined tools---
predefinedTools = False

#---widgets that are displayed to set the parameters---
# T=Text, N=NumberValues, O=OptionList, F=FileButton, C=CheckBox
widget = ("T","T","O","T","T","T","N","N","N","N")

#---parameter of the module---
labels    = ("", "","Manual tool","Info","Enable","Disable","X offset","Y offset","Tool length (Z Abs)","Diameter")

#---option presets for listed parameters---
options   = {"Manual tool"       :     ["100"] }



class module( object ):
    #############################################################################
    #                                                                           #
    #    02.00 g-code generator                                                 #
    #                                                                           #
    #############################################################################
    def gcode( self, jTools, joblist, jIndex, preview=0 ):
        L = uni.language 

        #########################################################################
        #    02.01 local vars                                                   #
        #########################################################################

        #---extrace name, tool and param rows from joblist table---
        jNames = [job[1] for job in joblist]
        jParams = [job[2:] for job in joblist] #for contents, see labels

        #---variable values---
        code          = ("\n("+("-"*30)+L[name]+jNames[jIndex][-4:]+("-"*30)+")\n"+
                         "("+L["Tool"]+": "+jParams[jIndex][2]+")\n\n")
                         
        return code 
   

   
    #############################################################################
    #                                                                           #
    #    03.00 determine start-/endtool                                         #
    #                                                                           #
    #############################################################################
    # function returns start/endtool of THIS module for toolOptimizer 
    # "" will be ignored by optimizer 
    # "nT" will force to load no Tool
    def tool( self, joblist, jIndex ):
        
        return ("","") #(Start, Endtool)

        
