#!/usr/bin/env bash

#---Install Depending Packages---
sudo apt-get --ignore-missing --assume-yes install python3 python3-pyqt5 libpotrace0 potrace 

#---Copy Files---
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
sudo mkdir /usr/share/lonnox-cut
echo 'copy files to /usr/share/lonnox-cut...'
sudo cp -ar "$DIR"/. /usr/share/lonnox-cut

#---Create Menu Links---
APPS='/usr/share/applications/lonnox-cut.desktop'
sudo echo '[Desktop Entry]' 				 > "$APPS"
sudo echo 'Encoding=UTF-8' 				>> "$APPS"
sudo echo 'Version=' 					>> "$APPS"
sudo echo 'Type=Application' 				>> "$APPS"
sudo echo 'Exec=python3 /usr/share/lonnox-cut/LCUT.py'	>> "$APPS"
sudo echo 'Icon=/usr/share/lonnox-cut/data/icon.png'    >> "$APPS"
sudo echo 'X-GNOME-DocPath=' 				>> "$APPS"
sudo echo 'Terminal=false'  				>> "$APPS"
sudo echo 'Name=Lonnox CUT' 				>> "$APPS"
sudo echo 'Comment=GCode Editor' 			>> "$APPS"
sudo echo 'StartupNotify=false' 			>> "$APPS"
sudo echo 'Categories=X-CNC;Utility;' 			>> "$APPS"
echo 'create Menu Links ...done'

#---Create Desktop Links---
DESK="$( cd "$( dirname "${xdg-user-dir DESKTOP}" )" && pwd )"
if [ "$(locale | grep LANG | cut -d= -f2 | cut -d_ -f1)" == "de" ]
then
    sudo cp /usr/share/applications/lonnox-cut.desktop "$DESK"/Arbeitsfläche
    echo 'create Desktop Link ...done'
elif [ "$(locale | grep LANG | cut -d= -f2 | cut -d_ -f1)" == "en" ]
then
    sudo cp /usr/share/applications/lonnox-cut.desktop "$DESK"/Desktop
    echo 'create Desktop Link ...done'
fi

